package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.media.stream

import java.io.File

/**
 * Listener for the media stream lifecycle.
 */
internal interface MediaStreamListener {
    val lastStreamStatus: MediaStreamStatus

    /**
     * Callbacks for the stream lifecycle.
     */
    fun onStreamStarted(file: File)
    fun onStreamProgress(file: File, progress: MediaStreamStatus.Progress)
    fun onStreamComplete(result: MediaStreamStatus.Complete)
    fun onStreamError(error: MediaStreamStatus.Failure)
}
