package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.staticrenderer.model

/**
 * A data class used to record the position of the last ad touch.
 *
 * @property viewPositionX The X-coordinate of the ad view's position on the screen.
 * @property viewPositionY The Y-coordinate of the ad view's position on the screen.
 * @property viewSizeHeight The height of the ad view.
 * @property viewSizeWidth The width of the ad view.
 * @property touchX The X-coordinate of the touch event within the ad view.
 * @property touchY The Y-coordinate of the touch event within the ad view.
 */
internal data class AdTouch(
    val viewPositionX: Int,
    val viewPositionY: Int,
    val viewSizeHeight: Int,
    val viewSizeWidth: Int,
    val touchX: Int,
    val touchY: Int
)
