package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.templates.ad.loader

import com.moloco.sdk.internal.MolocoLogger
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.AdLoad
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.templates.renderer.TemplateWebView
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.launch
import kotlin.time.Duration
import com.moloco.sdk.internal.Result

internal class WebViewAdLoad(private val adm: String,
                             private val scope: CoroutineScope,
                             val webView: TemplateWebView
) : AdLoad {
    private val _isLoaded = MutableStateFlow(false)
    override val isLoaded: StateFlow<Boolean> = _isLoaded
    override fun load(timeout: Duration, listener: AdLoad.Listener?) {
        scope.launch {
            when(val result =  webView.loadHtml(adm, timeout)) {
                is Result.Success -> {
                    MolocoLogger.info(TAG, "WebViewAdLoad: load success")
                    _isLoaded.value = true
                    listener?.onLoad()
                }
                is Result.Failure -> {
                    MolocoLogger.info(TAG, "WebViewAdLoad: load failure")
                    _isLoaded.value = false
                    listener?.onLoadError(result.value)
                }
            }
        }
    }

    companion object {
        private const val TAG = "WebViewAdLoad"
    }
}
