package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.templates.renderer

import android.webkit.JavascriptInterface
import com.moloco.sdk.BuildConfig
import com.moloco.sdk.internal.MolocoLogger
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.templates.renderer.events.handlers.CompositeEventHandler


class TemplateJavascript(private val eventHandler: CompositeEventHandler) {
    @JavascriptInterface
    fun log(message: String) {
        MolocoLogger.info(TAG, message)
    }

    @JavascriptInterface
    fun onEvent(event: String) {
        eventHandler.handleEvent(event)
    }

    @JavascriptInterface
    fun sdkVersion(): String {
        return BuildConfig.SDK_VERSION_NAME
    }

    companion object {
        private const val TAG = "TemplateJavascript"
    }
}
