package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.templates.renderer.events.handlers

import com.moloco.sdk.acm.AndroidClientMetrics
import com.moloco.sdk.acm.CountEvent
import com.moloco.sdk.acm.TimerEvent
import com.moloco.sdk.internal.MolocoLogger
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.templates.renderer.events.EventHandler
import org.json.JSONObject

class ACMHandler : EventHandler {
    override val TAG: String
        get() = "ACMHandler"

    override val supportedEvents: Set<String>
        get() = setOf("metric")

    override fun handleEvent(event: JSONObject) {
        val eventName = event.getString("event")
        val metricName = event.getString("metricName")
        val metricType = event.getString("type")
        val tags = event.optJSONArray("tags")
        val metricValue = event.getString("value")
        when (metricType) {
            "counter" -> {
                MolocoLogger.debug(TAG, "Count metric recorded: $metricName = $metricValue")
                var countEvent = CountEvent(metricName).apply {
                    withCount(metricValue.toInt())
                }
                tags?.let {
                    for (i in 0 until it.length()) {
                        val tag = it.getJSONObject(i)
                        val key = tag.keys().next()
                        val value = tag.getString(key)
                        countEvent = countEvent.withTag(key, value)
                    }
                }
                AndroidClientMetrics.recordCountEvent(countEvent)
            }
            "timer" -> {
                MolocoLogger.debug(TAG, "Timer metric recorded: $metricName = $metricValue")
                var timerEvent = TimerEvent.create(metricName)
                timerEvent.withTime(metricValue.toLong())
                tags?.let {
                    for (i in 0 until it.length()) {
                        val tag = it.getJSONObject(i)
                        val key = tag.keys().next()
                        val value = tag.getString(key)
                        timerEvent = timerEvent.withTag(key, value)
                    }
                }
                AndroidClientMetrics.recordTimerEvent(timerEvent)
            }
            else -> {
                MolocoLogger.warn(TAG, "Unknown event type: $eventName")
            }
        }
    }
}
