package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.templates.renderer.events.handlers

import com.moloco.sdk.internal.MolocoLogger
import com.moloco.sdk.internal.services.ClickthroughService
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.templates.renderer.events.EventHandler
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.flow.MutableSharedFlow
import kotlinx.coroutines.launch
import org.json.JSONObject

internal class ClickthroughEventHandler(
    private val clickthroughService: ClickthroughService,
    private val scope: CoroutineScope = CoroutineScope(Dispatchers.Main)
) : EventHandler {
    private val _clickthroughEvent = MutableSharedFlow<Unit>()
    val clickthroughEvent = _clickthroughEvent

    override val TAG: String
        get() = "ClickthroughEventHandler"

    override val supportedEvents: Set<String>
        get() = setOf("clickthrough")

    override fun handleEvent(event: JSONObject) {
        if (event.getString("event") != supportedEvents.first()) {
            MolocoLogger.debug(TAG, "Event not supported: ${event.getString("event")}")
            return
        }
        val contentClicked = event.getString("contentType")
        MolocoLogger.debug(TAG, "Ad clicked on $contentClicked")
        val url = event.getString("url")
        scope.launch {
            clickthroughService.runTemplateAdClickThrough(url, _clickthroughEvent)
        }

    }

}
