package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.templates.renderer.events.handlers

import com.moloco.sdk.internal.MolocoLogger
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.templates.renderer.events.EventHandler
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.flow.MutableSharedFlow
import kotlinx.coroutines.launch
import org.json.JSONObject

internal class CloseHandler(private val scope: CoroutineScope = CoroutineScope(Dispatchers.Main)) : EventHandler {

    private val _closeEvent = MutableSharedFlow<Unit>()
    internal val closeEvent = _closeEvent

    override val TAG: String
        get() = "CloseHandler"

    override val supportedEvents: Set<String>
        get() = setOf("close")

    override fun handleEvent(event: JSONObject) {
        if (event.getString("event") != supportedEvents.first()) {
            MolocoLogger.debug(TAG, "Event not supported: ${event.getString("event")}")
            return
        }
        scope.launch {
            _closeEvent.emit(Unit)
        }
    }
}
