package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.templates.renderer.events.handlers

import com.moloco.sdk.internal.MolocoLogger
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.templates.renderer.events.EventHandler
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.flow.MutableSharedFlow
import kotlinx.coroutines.launch
import org.json.JSONObject

internal class PlayListItemDisplayingEventHandler(private val scope: CoroutineScope = CoroutineScope(Dispatchers.Main)) : EventHandler {

    private val _playlistItemDisplaying = MutableSharedFlow<PlaylistContainerType>()
    internal val playlistItemDisplaying = _playlistItemDisplaying

    override val TAG: String
        get() = "PlayListItemDisplayingEventHandler"

    override val supportedEvents: Set<String>
        get() = setOf("playlistItemDisplaying")

    override fun handleEvent(event: JSONObject) {
        MolocoLogger.debug(TAG, "${event.toString()} displaying.")
        if (event.getString("event") != supportedEvents.first()) {
            MolocoLogger.debug(TAG, "Event not supported: ${event.getString("event")}")
            return
        }
        val containerTypeString = event.getString("creativeType")
        val containerType = PlaylistContainerType.fromString(containerTypeString)
        MolocoLogger.debug(TAG, "$containerType displaying.")

        if (containerType != null) {
            scope.launch {
                _playlistItemDisplaying.emit(containerType)
            }
        }
    }

    // As defined by the Ad Template
    internal enum class PlaylistContainerType(val value: String) {
        VIDEO("videoContainer"),
        MRAID("mraidContainer"),
        STATIC("staticContainer");

        companion object {
            fun fromString(value: String): PlaylistContainerType? {
                return values().find { it.value == value }
            }
        }
    }
}
