package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui

import androidx.compose.animation.AnimatedVisibility
import androidx.compose.foundation.layout.BoxScope
import androidx.compose.foundation.layout.PaddingValues
import androidx.compose.foundation.layout.displayCutoutPadding
import androidx.compose.foundation.layout.padding
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.DpSize
import androidx.compose.ui.unit.TextUnit
import com.moloco.sdk.internal.ortb.model.CountDownTimer
import com.moloco.sdk.xenoss.sdkdevkit.android.core.services.CustomUserEventBuilderService

// TODO. Move to a proper place.
typealias ExtraOnClick = () -> Unit

// TODO. "enabled", "secondsLeft" are mutually exclusive.
//  Consider extracting them into a sealed class
//  similar to AdViewModel.GoNextAction.
/**
 * Base ad countdown high-level type for VAST, MRAID, Static ad's skip/close countdown buttons.
 *
 * _Consider it as a stateless_
 */
internal typealias AdCountdownButton = @Composable BoxScope.(
    enabled: Boolean,
    visible: Boolean,
    onClick: () -> Unit,
    onButtonRendered: (CustomUserEventBuilderService.UserInteraction.Button) -> Unit,
    enableCountDownTimer: Boolean, // Based on the ad part of the ad, tells us to render the CountDown Timer - Check AdGoNextButton.kt
    totalCountDownTime: UInt,
    currentCountDownTime: UInt
) -> Unit

/**
 * [AdCountdownButton] stateless implementation for all skip/close countdown ad buttons.
 * Telepathy tracking is already included [TrackableButton].
 * Practically is a stateless composable.
 */
@Composable
internal fun adCountdownButton(
    alignment: Alignment,
    padding: PaddingValues,
    color: Color,
    size: DpSize,
    fontSize: TextUnit,
    afterCountdownButtonPart: CountdownButtonPart,
    buttonType: CustomUserEventBuilderService.UserInteraction.Button.ButtonType,
    extraOnClick: ExtraOnClick?,
    countDownTimer: CountDownTimer?
): AdCountdownButton = { enabled, visible, onClick, onButtonRendered, enableCountDownTimer, totalCountDownTime, currentCountDownTime ->

    AnimatedVisibility(
        visible = visible,
        modifier = Modifier
            .align(alignment)
            .displayCutoutPadding()
            .padding(padding)
    ) {
        TrackableButton(
            modifier = Modifier,
            buttonType = buttonType,
            onButtonRendered = onButtonRendered
        ) { modifier ->
            CountdownButton(
                countdownButtonPart = if (enabled) {
                    afterCountdownButtonPart
                } else {
                    CountdownButtonPart.Countdown(enableCountDownTimer, totalCountDownTime, currentCountDownTime)
                },
                modifier = modifier,
                onClick = {
                    onClick()
                    extraOnClick?.invoke()
                },
                enabled = enabled,
                color = color,
                size = size,
                fontSize = fontSize,
                countDownTimer = countDownTimer,
            )
        }
    }
}
