package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui

import androidx.compose.foundation.layout.PaddingValues
import androidx.compose.material.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.Shape
import androidx.compose.ui.graphics.painter.Painter
import androidx.compose.ui.res.painterResource
import androidx.compose.ui.unit.DpSize
import androidx.compose.ui.unit.TextUnit
import com.moloco.sdk.R
import com.moloco.sdk.internal.ortb.model.CountDownTimer
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui.utils.DEFAULT_AD_BUTTON_PADDING
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui.utils.DEFAULT_BUTTON_DP_SIZE
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui.utils.DEFAULT_FONT_SIZE
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui.utils.DEFAULT_ICON_BUTTON_BACKGROUND_COLOR
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui.utils.DEFAULT_ICON_BUTTON_BACKGROUND_SHAPE
import com.moloco.sdk.xenoss.sdkdevkit.android.core.services.CustomUserEventBuilderService

@Composable
internal fun defaultAdCloseCountdownButton(
    alignment: Alignment = Alignment.TopEnd,
    padding: PaddingValues = PaddingValues(DEFAULT_AD_BUTTON_PADDING),
    color: Color = MaterialTheme.colors.primary,
    size: DpSize = DEFAULT_BUTTON_DP_SIZE,
    fontSize: TextUnit = DEFAULT_FONT_SIZE,
    afterCountdownButtonPart: CountdownButtonPart = adCloseAfterCountdownIcon(),
    extraOnClick: ExtraOnClick? = null,
    countDownTimer: CountDownTimer? = null
): AdCountdownButton = adCountdownButton(
    alignment,
    padding,
    color,
    size,
    fontSize,
    afterCountdownButtonPart,
    CustomUserEventBuilderService.UserInteraction.Button.ButtonType.CLOSE,
    extraOnClick,
    countDownTimer
)

@Composable
internal fun adCloseAfterCountdownIcon(
    painter: Painter = painterResource(id = R.drawable.ic_round_close_24),
    iconSize: DpSize = DEFAULT_BUTTON_DP_SIZE,
    backgroundShape: Shape = DEFAULT_ICON_BUTTON_BACKGROUND_SHAPE,
    backgroundColor: Color = DEFAULT_ICON_BUTTON_BACKGROUND_COLOR
): CountdownButtonPart = CountdownButtonPart.IconButton(
    painter,
    contentDescription = "Close",
    iconSize = iconSize,
    backgroundShape = backgroundShape,
    backgroundColor = backgroundColor
)
