package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui.utils

import android.content.res.Resources
import androidx.compose.ui.geometry.Offset
import androidx.compose.ui.layout.LayoutCoordinates
import androidx.compose.ui.layout.positionInRoot
import com.moloco.sdk.xenoss.sdkdevkit.android.core.services.CustomUserEventBuilderService
import com.moloco.sdk.xenoss.sdkdevkit.android.core.services.CustomUserEventBuilderService.UserInteraction.Button

object ScreenUtils {
    fun toDp(px: Int): Float {
        val displayMetrics = Resources.getSystem().displayMetrics
        return px / displayMetrics.density
    }

    fun LayoutCoordinates.toPosition(): CustomUserEventBuilderService.UserInteraction.Position {
        val xPx = positionInRoot().x.toInt()
        val xDp = toDp(xPx)
        val yPx = positionInRoot().y.toInt()
        val yDp = toDp(yPx)

        return CustomUserEventBuilderService.UserInteraction.Position(
            topLeftXDp = xDp,
            topLeftYDp = yDp
        )
    }

    fun LayoutCoordinates.toSize(): CustomUserEventBuilderService.UserInteraction.Size {
        val heightPx = size.height
        val heightDp = toDp(heightPx)
        val widthPx = size.width
        val widthDp = toDp(widthPx)

        return CustomUserEventBuilderService.UserInteraction.Size(
            widthDp = widthDp,
            heightDp = heightDp
        )
    }

    fun Offset.toPosition(): CustomUserEventBuilderService.UserInteraction.Position {
        val xPx = x.toInt()
        val xDp = toDp(xPx)
        val yPx = y.toInt()
        val yDp = toDp(yPx)

        return CustomUserEventBuilderService.UserInteraction.Position(
            topLeftXDp = xDp,
            topLeftYDp = yDp
        )
    }

    fun LayoutCoordinates.toButton(
        buttonType: CustomUserEventBuilderService.UserInteraction.Button.ButtonType
    ) = CustomUserEventBuilderService.UserInteraction.Button(
        buttonType = buttonType,
        position = toPosition(),
        size = toSize()
    )

    fun Button.isNotZero(): Boolean {
        return size.heightDp > 0 && size.widthDp > 0
    }
}
