package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.compose

import androidx.compose.runtime.Composable
import androidx.compose.runtime.remember
import androidx.compose.ui.Modifier
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.BaseWebView
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.WebViewRepository
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.webview.AdWebView
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.PreparedVastResource

@Composable
fun VastResourceHtml(htmlResource: PreparedVastResource.Html, modifier: Modifier = Modifier) {
    val webView = remember {
        WebViewRepository.get<BaseWebView>(htmlResource.webViewId)
    } ?: return

    AdWebView(webView, modifier, null)
}
