package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.webview

/**
 * Handler responsible for applying CSS fixes to HTML content loaded in WebViews.
 *
 */
internal class HTMLCSSFixer {

    /**
    * Quick CSS fix for overriding default 8px margin/padding for body, removed zoom and overscrolling.
    *
    */
    private val CSSRenderingFixPrefix = """
        <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no"> 
        <style> body { margin:0; padding:0; overflow:hidden; } </style>
        """

    //

    /**
     * Applies CSS rendering fix to the provided HTML content.
     *
     * This method prepends the CSS rendering fix to the HTML content, ensuring that
     * the WebView displays the content without default margins or padding, and prevents
     * zooming and overscrolling behaviors that can disrupt the intended layout.
     *
     * @param toHtml The original HTML content that needs CSS fixes applied
     * @return The modified HTML content with CSS fixes prepended
     */
    internal fun applyCSSRenderingFix(toHtml: String): String = CSSRenderingFixPrefix + toHtml
}
