package com.moloco.sdk.common_adapter_internal

import android.content.Context
import androidx.annotation.RestrictTo
import com.moloco.sdk.Init.SDKInitResponse
import com.moloco.sdk.internal.appendXMolocoUserAgent
import com.moloco.sdk.publisher.MediationInfo
import com.moloco.sdk.publisher.Moloco
import com.moloco.sdk.publisher.bidrequest.Geo
import com.moloco.sdk.service_locator.SdkObjectFactory
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.ScreenService
import com.moloco.sdk.xenoss.sdkdevkit.android.core.UserAgentService
import com.moloco.sdk.xenoss.sdkdevkit.android.core.requestTimeoutMillis
import io.ktor.client.HttpClient
import io.ktor.client.request.HttpRequestBuilder
import io.ktor.http.HeadersBuilder

/**
 * Exposes SDK functionality as public functionality for Moloco Custom Adapter access.
 * This should not be used outside of Moloco group as this can be removed at anytime
 */
@RestrictTo(RestrictTo.Scope.LIBRARY_GROUP)
object AdapterAccess {
    @JvmStatic
    fun sessionData(adUnitId: String): AdapterSessionData? =
        SdkObjectFactory.Initialization.initSingleton.currentSessionInitResponse?.toAdapterSessionData(adUnitId)

    fun ApplicationContext(context: Context? = null): Context =
        com.moloco.sdk.internal.android_context.ApplicationContext(context)

    fun HeadersBuilder.appendMolocoUserAgent(
        molocoSdkVersion: String?,
        androidOSVersion: String?,
        mediationInfo: MediationInfo?,
    ) = appendXMolocoUserAgent(molocoSdkVersion, androidOSVersion, mediationInfo)

    fun HttpRequestBuilder.httpRequestTimeoutMillis(millis: Long) = requestTimeoutMillis(millis)
    fun UserAgentService(): UserAgentService =
        com.moloco.sdk.xenoss.sdkdevkit.android.core.UserAgentService()

    fun HttpClient(): HttpClient = SdkObjectFactory.Network.httpClientSingleton

    fun screenData(context: Context = ApplicationContext()) = ScreenService(context).invoke()
    fun DispatcherProvider() = com.moloco.sdk.internal.scheduling.DispatcherProvider()
}

data class AdapterSessionData(

    val geo: Geo,
    val bidRequestEndpoint: String?,
    val appId: String?,
    val publisherId: String?,
    val platformId: String?,
    val adUnitName: String?,
    val bidFloor: Float?,
)

private val DefaultGeo = Geo(null, null, null, null, null, null)

private fun SDKInitResponse.toAdapterSessionData(adUnitId: String): AdapterSessionData {
    return AdapterSessionData(
        geo = this.geo?.let {
            Geo(
                city = it.city,
                country = it.countryIso3Code,
                zipCode = it.zipCode,
                region = it.countryIso2Code,
                latitude = it.latitude,
                longitude = it.longitude
            )
        } ?: DefaultGeo,
        bidRequestEndpoint = Moloco.bidRequestEndpoint,
        appId = appId,
        publisherId = publisherId,
        platformId = platformId,
        adUnitName = adUnitsList?.firstOrNull { it.id == adUnitId }?.name,
        bidFloor = adUnitsList?.firstOrNull { it.id == adUnitId }?.bidFloor
    )
}
