package com.moloco.sdk.internal.error.api

import com.moloco.sdk.internal.MolocoLogger
import com.moloco.sdk.internal.error.ErrorMetadata
import com.moloco.sdk.internal.services.TimeProviderService
import com.moloco.sdk.internal.utils.substituteErrorAndTimestampMacro
import com.moloco.sdk.internal.utils.substituteMTIDMacro
import com.moloco.sdk.xenoss.sdkdevkit.android.persistenttransport.BestAttemptPersistentHttpRequest

typealias Url = String
internal interface ErrorReportingApi {
    fun reportFatalError(error: Throwable)

    fun reportNonFatalError(error: String, url: Url, errorMetadata: ErrorMetadata)
}

internal class ErrorReportingApiImpl(
    private val timeProviderService: TimeProviderService,
    private val httpClient: BestAttemptPersistentHttpRequest
) : ErrorReportingApi {

    private val TAG = "ErrorReportingApi"

    override fun reportFatalError(error: Throwable) {
        MolocoLogger.error(TAG, "SDK Crashed", error)
        // TODO: Report crash to endpoint via httpClient
    }

    override fun reportNonFatalError(error: String, url: Url, errorMetadata: ErrorMetadata) {
        val time = timeProviderService.invoke()
        val errorUrl = url.substituteErrorAndTimestampMacro(error, time).substituteMTIDMacro(errorMetadata.mtid)
        MolocoLogger.info(TAG, "Reporting error: $error to url: $errorUrl")
        httpClient.send(errorUrl)
    }
}
