package com.moloco.sdk.internal.ortb.model

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
internal class BidResponse(
    @SerialName("seatbid") val seatBid: List<SeatBid>
)

@Serializable
internal class SeatBid(
    @SerialName("bid") val bid: List<Bid>,
)

@Serializable
internal class Bid(
    @SerialName("adm") val adm: String,
    @SerialName("price") val price: Float,
    @SerialName("burl") val burl: String? = null,
    @SerialName("ext") val ext: BidExt,
)

@Serializable
internal class MolocoSDKConfigs(
    @SerialName("server_rendering_enabled") val serverRenderingEnabled: Boolean? = null, // Client sdk can be configured to render v2 rendering
)

@Serializable
internal class BidExt(
    @SerialName("player") val player: Player? = null, // NativeAds may not have player hence nullable
    @SerialName("mtid") val mtid: String? = null, // Client sdk can associate the bid with this mtid
    @SerialName("moloco_sdk_configs") val configs: MolocoSDKConfigs? = null, // Client sdk can be configured via this field
    @SerialName("moloco_sdk_events") val sdkEvents: SdkEvents? = null, // Todo: should be not be nullable. https://mlc.atlassian.net/browse/SDK-3123,
    @SerialName("moloco_sdk_click_metadata") val molocoSdkClickMetaData: MolocoSDKClickMetaData?  = null // Click metadata for sdk
)

/**
 * Moloco SDK Click metadata.
 *
 * @property bannerClickMeta Metadata for banner clicks.
 */
@Serializable
internal class MolocoSDKClickMetaData(
    @SerialName("banner") val bannerClickMetaData: BannerClickMetaData? = null
)

/**
 * Metadata related to banner clicks.
 *
 * @property clickTracking If the clickthrough does not have click tracking, we will make use of this field to fire click tracking.
 * @property clickThrough The destination URL when the banner is clicked, which may have click tracking embedded and redirect to the play store.
 *                          This property will send users to the play store. If click tracking is not embedded in this field, we will use the clickTracking field.
 *                          This aligns with iOS click behavior - due to storekit.
 */
@Serializable
internal class BannerClickMetaData(
    @SerialName("click_tracking") val clickTracking: String? = null,
    @SerialName("click_through") val clickThrough: String? = null,
)

internal fun Bid.mtid(): String {
    return ext.mtid ?: "UNKNOWN_MTID"
}
