package com.moloco.sdk.internal.services

import android.content.Context
import android.content.pm.PackageManager
import androidx.webkit.WebViewCompat

internal class WebViewAvailabilityChecker(private val context: Context) {
    fun checkAvailability(): Result<Unit> {
        val webViewPackageInfo = WebViewCompat.getCurrentWebViewPackage(context)
            ?: return Result.failure(Exception("No current WebView package exists"))

        val setting = context.packageManager.getApplicationEnabledSetting(webViewPackageInfo.packageName)

        return when (setting) {
            PackageManager.COMPONENT_ENABLED_STATE_DISABLED -> {
                Result.failure(Exception("WebView component is disabled by system"))
            }
            PackageManager.COMPONENT_ENABLED_STATE_DISABLED_USER -> {
                Result.failure(Exception("WebView component is disabled by user"))
            }
            PackageManager.COMPONENT_ENABLED_STATE_DISABLED_UNTIL_USED -> {
                Result.failure(Exception("WebView component is disabled until used"))
            }
            else -> Result.success(Unit)
        }
    }
}
