package com.moloco.sdk.internal.services.bidtoken.providers

import com.moloco.sdk.internal.MolocoLogger
import com.moloco.sdk.internal.services.AudioService
import com.moloco.sdk.internal.services.MuteSwitchState


internal data class AudioSignal(
    /**
     * Ringer state of the device
     */
    val muteSwitchState: MuteSwitchState? = null,
    /**
     * Volume of audio streams for music playback
     */
    val mediaVolume: Int? = null,
)

internal class AudioSignalProvider(private val audioService: AudioService): ClientBidTokenSignalProvider<AudioSignal> {
    private var cachedSignal = getAudioSignal()

    override fun needsRefresh(): Boolean {
        val currentSignal = getAudioSignal()
        val needsRefresh = currentSignal != cachedSignal
        MolocoLogger.debugBuildLog(TAG, "[CBT] needsRefresh: $needsRefresh, with current: $currentSignal, cached: $cachedSignal")
        return needsRefresh
    }

    override fun tryUpdateSignalState() {
        cachedSignal = getAudioSignal()
    }

    override fun provideSignal(): AudioSignal {
        return cachedSignal
    }

    override fun logTag(): String = TAG

    private fun getAudioSignal(): AudioSignal {
        try {
            return AudioSignal(
                muteSwitchState = audioService.muteSwitchState,
                mediaVolume = audioService.mediaVolume,
            )
        } catch (e: Exception) {
            MolocoLogger.error(TAG, "[CBT] AS Error", e)
            return AudioSignal()
        }
    }

    companion object {
        private const val TAG = "AudSignalProvider"
    }
}
