package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer

import androidx.compose.runtime.Composable
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui.AdCountdownButton
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui.defaultAdCloseCountdownButton
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.compose.VastRenderer
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.compose.defaultVastRenderer
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.webview.AdWebViewRenderer
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.webview.defaultAdWebViewRenderer

/**
 * Represents the options to configure the ad at rendering time
 */
interface AdRenderingOptions

/**
 * @param closeDelaySeconds null - close functionality available immediately
 * @param adWebViewRenderer layout for rendering WebView based ad
 * @param decGoNextActionDelaySeconds delay seconds for displaying the next ad part
 * @param decClose dec close button data
 */
internal class AdWebViewOptions(
    val closeDelaySeconds: Int = DEFAULT_CLOSE_DELAY_SECONDS,
    val adWebViewRenderer: AdWebViewRenderer = defaultAdWebViewRenderer(),
    val decGoNextActionDelaySeconds: Int = DEFAULT_CLOSE_DELAY_SECONDS,
    val decClose: @Composable () -> AdCountdownButton? = { defaultAdCloseCountdownButton() }
) : AdRenderingOptions

/**
 * @param startMuted whether video starts muted or not
 * @param overrideLinearGoNextActionEnabled null: VAST linear skip/"go next" action availability relies on VAST xml ad markup's <Skippable> tag value; otherwise skip availability is decided by the Boolean value of this parameter.
 * @param overrideLinearGoNextActionEnabledDelaySeconds ignored when [overrideLinearGoNextActionEnabled] is null; otherwise skip action availability delay is decided by the Int value of this parameter.
 * @param companionGoNextActionDelaySeconds amount of seconds till "go next" action is available for Companion(endcard) ad parts.
 * @param decGoNextActionDelaySeconds amount of seconds till "go next" action is available for DEC ad parts.
 * @param autoStoreOnSkip Moloco feature: if user clicks skip button, open clicktrough link without VAST click tracking.
 * @param autoStoreOnComplete Moloco feature: if video completes, open clicktrough link without VAST click tracking.
 * @param VastRenderer layout for rendering VAST ad
 */
class VastOptions(
    val startMuted: Boolean = true,
    val overrideLinearGoNextActionEnabled: Boolean? = null,
    val overrideLinearGoNextActionEnabledDelaySeconds: Int = 5,
    val companionGoNextActionDelaySeconds: Int = DEFAULT_CLOSE_DELAY_SECONDS,
    val decGoNextActionDelaySeconds: Int = DEFAULT_CLOSE_DELAY_SECONDS,
    val autoStoreOnSkip: Boolean = false,
    val autoStoreOnComplete: Boolean = false,
    val VastRenderer: VastRenderer = defaultVastRenderer()
) : AdRenderingOptions

/**
 * An aggregated options class that combines options for VAST, MRAID, and static ads.
 *
 * @param vastOptions - options for a simple html ad
 * @param mraidOptions - options for a simple html ad
 * @param staticOptions - options for a simple html ad
 */
internal class AggregatedOptions(
    val vastOptions: VastOptions,
    val mraidOptions: AdWebViewOptions,
    val staticOptions: AdWebViewOptions
) : AdRenderingOptions

/**
 * Ad rendering options for template. Since template handle them at the javascript layer
 * this is a stateless no-op option to comply with the old legacy typed generics
 */
internal class TemplateAdOptions : AdRenderingOptions

const val DEFAULT_CLOSE_DELAY_SECONDS = 5
