package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer

import android.content.Context
import android.os.Build
import android.util.DisplayMetrics
import android.view.WindowManager
import androidx.annotation.RequiresApi
import androidx.core.content.ContextCompat
import com.moloco.sdk.common_adapter_internal.ScreenData
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.pxToDp

internal fun ScreenService(context: Context): ScreenService = ScreenServiceImpl(context)

interface ScreenService {
    operator fun invoke(): ScreenData
}

private class ScreenServiceImpl(private val context: Context) : ScreenService {
    override fun invoke(): ScreenData {
        // This does not take into account the top status bar height, that's
        // why we don't use this approach. Keeping it around for documentation
        // val displayMetrics = Resources.getSystem().displayMetrics
        // val dpHeight = displayMetrics.heightPixels / displayMetrics.density
        // val dpWidth = displayMetrics.widthPixels / displayMetrics.density

        val windowManager = ContextCompat.getSystemService(context, WindowManager::class.java)
            ?: return ScreenData(0, 0, 0f, 0f, 0, 0.0f)

        val displayMetrics = if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.R) {
            windowManager.displayMetricsApi30Plus()
        } else {
            windowManager.displayMetrics()
        }

        return displayMetrics.let {
            ScreenData(
                widthPx = it.widthPixels,
                heightPx = it.heightPixels,
                widthDp = pxToDp(it.widthPixels, it.density),
                heightDp = pxToDp(it.heightPixels, it.density),
                dpi = it.densityDpi,
                pxRatio = it.density
            )
        }
    }

    @RequiresApi(Build.VERSION_CODES.R)
    private fun WindowManager.displayMetricsApi30Plus() = DisplayMetrics().apply {
        density = context.resources.displayMetrics.density
        densityDpi = context.resources.displayMetrics.densityDpi
        widthPixels = currentWindowMetrics.bounds.width()
        heightPixels = currentWindowMetrics.bounds.height()
    }

    @Suppress("DEPRECATION")
    private fun WindowManager.displayMetrics() = DisplayMetrics().also {
        defaultDisplay.getRealMetrics(it)
    }
}
