package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal

import android.content.Context
import android.view.ViewGroup
import android.webkit.WebView
import androidx.webkit.WebViewAssetLoader
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.webview.HTMLCSSFixer

internal open class BaseWebView(context: Context) : WebView(context.applicationContext) {
    val htmlCssFixer = HTMLCSSFixer()

    // This kind of helps avoiding WebView memory leaks.
    override fun destroy() {
        (parent as? ViewGroup)?.removeView(this)
        removeAllViews()
        // TODO. IMPORTANT. Delay for OMID.
        super.destroy()
    }
}

fun WebView.loadDataWithDefaultBaseUrl(data: String) {
    this.loadDataWithBaseURL(DEFAULT_BASE_URL, data, "text/html", "utf-8", null)
}

// https://developer.android.com/reference/androidx/webkit/WebViewAssetLoader
private const val DEFAULT_BASE_URL = "https://${WebViewAssetLoader.DEFAULT_DOMAIN}"
