package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal

import com.moloco.sdk.internal.Result
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.AdLoad
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.staticrenderer.StaticWebView
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.launch
import kotlin.time.Duration

internal class StaticAdLoad(
    private val adm: String,
    private val scope: CoroutineScope,
    private val staticWebView: StaticWebView
) : AdLoad {
    private val TAG = "StaticAdLoad"
    private val _isLoaded = MutableStateFlow(false)
    override val isLoaded: StateFlow<Boolean> = _isLoaded

    override fun load(timeout: Duration, listener: AdLoad.Listener?) {
        scope.launch {
            when (val adLoadResult = staticWebView.loadHtml(adm, timeout)) {
                is Result.Success -> {
                    _isLoaded.value = true
                    listener?.onLoad()
                }
                is Result.Failure -> {
                    listener?.onLoadError(adLoadResult.value)
                }
            }
        }
    }
}
