package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.errors

enum class VastAdLoadError : MolocoAdSubErrorType {
    VAST_AD_LOAD_INCOMPLETE_ERROR,

    // Parse Errors
    VAST_AD_LOAD_XML_PARSE_ERROR,
    VAST_AD_LOAD_NO_XML_TAG_ERROR,

    // VAST Errors
    VAST_AD_LOAD_NO_ADS_ERROR,
    VAST_AD_LOAD_WRAPPER_LIMIT_ERROR,
    VAST_AD_LOAD_WRAPPER_TIMEOUT_ERROR,
    VAST_AD_LOAD_WRAPPER_FETCH_ERROR,
    VAST_AD_LOAD_INLINE_CREATIVES_EMPTY_ERROR,
    VAST_AD_LOAD_INLINE_CREATIVES_NO_LINEAR_ERROR,
    VAST_AD_LOAD_LINEAR_NOT_SUPPORTED_MEDIA_ERROR,

    // VAST Media File Errors
    VAST_AD_LOAD_MEDIA_FILE_CLIENT_HTTP_ERROR,
    VAST_AD_LOAD_MEDIA_FILE_SERVER_HTTP_ERROR,
    VAST_AD_LOAD_MEDIA_FILE_NO_NETWORK_HTTP_ERROR,
    VAST_AD_LOAD_MEDIA_FILE_UNKNOWN_HOST_HTTP_ERROR,
    VAST_AD_LOAD_MEDIA_FILE_SOCKET_HTTP_ERROR,
    VAST_AD_LOAD_MEDIA_FILE_HTTP_DISK_IO_ERROR,
    VAST_AD_LOAD_MEDIA_FILE_HTTP_DISK_SECURITY_ERROR,
    VAST_AD_LOAD_MEDIA_FILE_HTTP_SSL_ERROR,

    VAST_AD_LOAD_MEDIA_TMP_FILE_NOT_RENAMED_DISK_ERROR,
    VAST_AD_LOAD_MEDIA_FILE_NOT_CREATED_DISK_ERROR,
    VAST_AD_LOAD_MEDIA_FILE_NOT_CREATED_SECURITY_DISK_ERROR,
    VAST_AD_LOAD_MEDIA_FILE_NOT_CREATED_IO_DISK_ERROR,
    VAST_AD_LOAD_MEDIA_FILE_NOT_CREATED_UNKNOWN_DISK_ERROR,

    VAST_AD_LOAD_MEDIA_FILE_TIMEOUT_ERROR,
    VAST_AD_LOAD_MEDIA_FILE_TIMEOUT_NOT_ENOUGH_PLAYABLE_ERROR,
    VAST_AD_LOAD_MEDIA_FILE_UNABLE_TO_DETERMINE_TIMEOUT_ERROR,

    VAST_AD_LOAD_MEDIA_NUMBER_PARSE_ERROR,

    VAST_AD_LOAD_MEDIA_FILE_INVALID_URL_ERROR,
    VAST_AD_LOAD_MEDIA_FILE_NOT_FOUND_ERROR,
    VAST_AD_LOAD_MEDIA_FILE_UNKNOWN_MEDIA_FETCH_ERROR,
    VAST_AD_LOAD_MEDIA_FILE_UNKNOWN_ERROR, // [Should not ideally be reported] This means we need a more granular error check when loading media and are missing a scenario

    // When the vast ad loader could not load the RenderAd
    VAST_AD_LOAD_RENDER_AD_LOAD_ERROR,

    ;

    override val metricsRepresentation: String
        get() = name

    fun isTimeoutError(): Boolean {
        return this == VAST_AD_LOAD_MEDIA_FILE_TIMEOUT_ERROR || this == VAST_AD_LOAD_MEDIA_FILE_TIMEOUT_NOT_ENOUGH_PLAYABLE_ERROR || this == VAST_AD_LOAD_MEDIA_FILE_UNABLE_TO_DETERMINE_TIMEOUT_ERROR
    }
}

