package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.mraid

import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.templates.ad.orientation.AdOrientation

internal enum class MraidOrientation {
    Portrait,
    Landscape,
    None;

    companion object {
        fun from(string: String?): MraidOrientation? = when (string) {
            "portrait" -> Portrait
            "landscape" -> Landscape
            "none" -> None
            else -> null
        }
    }
}

internal fun MraidOrientation.toAdOrientation(): AdOrientation = when (this) {
    MraidOrientation.Portrait -> AdOrientation.Portrait
    MraidOrientation.Landscape -> AdOrientation.Landscape
    MraidOrientation.None -> AdOrientation.None
}
