package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.templates.ad.orientation

internal enum class AdOrientation {
    Portrait,
    Landscape,
    None;

    companion object {
        fun from(string: String?): AdOrientation? = when (string) {
            "portrait" -> Portrait
            "landscape" -> Landscape
            "none" -> None
            else -> null
        }
    }
}

internal data class OrientationSettings(val orientation: AdOrientation, val allowOrientationChange: Boolean = true)

