package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.templates.bridge

import android.webkit.WebView

internal interface TemplateBridge {
    /**
     * Notifies that the view is attached to the activity
     */
    fun viewReady()

    /**
     * Notifies that the content is visible
     */
    fun viewVisible(visible: Boolean)
}


internal class TemplateBridgeImpl(private val webView: WebView): TemplateBridge {
    override fun viewReady() {
        webView.evaluateJavascript("notifyReadyEvent()", null)
    }

    override fun viewVisible(visible: Boolean) {
        webView.evaluateJavascript("setIsViewable($visible)", null)
    }
}
