package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.templates.creative.mraid

import android.content.Context
import android.webkit.JavascriptInterface
import com.moloco.sdk.internal.MolocoLogger
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.mraid.MraidOrientation
import org.json.JSONObject

/**
 * Handles communication according to the MRAID 2.0 spec:
 * https://www.iab.com/wp-content/uploads/2015/08/IAB_MRAID_v2_FINAL.pdf
 */
internal class MraidJsEventReceiver(private val context: Context,
                                    private val mraidCommunicationHub: MraidCommunicationHub) {

    /**
     * Opens external links
     */
    @JavascriptInterface
    fun open(jsonParams: String) {
        val url = JSONObject(jsonParams).getString("url")
        mraidCommunicationHub.handleMRAIDJsCommandOpen(url)
    }

    /**
     * Changes the orientation of the Activity as dictated by the creative
     */
    @JavascriptInterface
    fun setOrientationProperties(jsonParams: String) {
        try {
            val jsonObject = JSONObject(jsonParams)
            val allowOrientationChange = jsonObject.optBoolean("allowOrientationChange", true)
            val forceOrientation = jsonObject.optString("forceOrientation", "none")

            MolocoLogger.debug(TAG, "Orientation Set from JSON: $allowOrientationChange, $forceOrientation")
            MraidOrientation.from(forceOrientation)?.let {
                mraidCommunicationHub.handleMraidJsCommandSetOrientationProperties(allowOrientationChange, it)
            }
        } catch (e: Exception) {
            MolocoLogger.error(TAG, "Error parsing orientation properties JSON", e)
        }
    }

    /**
     * Sets creative back to default state if expanded state
     * Removes creative if default state. In our case nothing on native
     */
    @JavascriptInterface
    fun close() {
        mraidCommunicationHub.handleMraidJsCommandClose()
    }

    /**
     * We currently don't support MRAID expand. This is reserved for MRAID banners.
     */
    @JavascriptInterface
    fun expand(url: String) {
        // Unsupported
    }

    /**
     * We currently don't support MRAID resize.
     */
    @JavascriptInterface
    fun resize(url: String) {
        // Unsupported
    }

    companion object {
        private const val TAG = "MraidJsEventReceiver"
    }
}
