package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.templates.renderer.events

import org.json.JSONObject

/**
 * Processes the events from the template.
 */
interface EventHandler {

    val TAG: String

    /**
     * The supported events for this handler. The event name is the key in the JSON object
     */
    val supportedEvents: Set<String>

    /**
     * Handles the event from the template. The caller is responsible for ensuring that
     * the handler can handle the event by checking the supported events
     */
    fun handleEvent(event: JSONObject)
}
