package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.templates.renderer.events.handlers

import com.moloco.sdk.acm.AndroidClientMetrics
import com.moloco.sdk.acm.CountEvent
import com.moloco.sdk.acm.TimerEvent
import com.moloco.sdk.internal.MolocoLogger
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.templates.renderer.events.EventHandler
import org.json.JSONObject

class ACMHandler : EventHandler {
    override val TAG: String
        get() = "ACMHandler"

    override val supportedEvents: Set<String>
        get() = setOf("metric")

    override fun handleEvent(event: JSONObject) {
        val eventName = event.getString("event")
        val metricName = event.getString("metricName")
        val metricType = event.getString("type")
        val tags = event.optJSONObject("tags")
        val metricValue = event.getString("value")

        when (metricType) {
            "counter" -> {
                MolocoLogger.debug(TAG, "Count metric recorded: $metricName = $metricValue")
                var countEvent = CountEvent(metricName).apply {
                    withCount(metricValue.toInt())
                }
                tags?.let {
                    for (key in it.keys()) {
                        countEvent = countEvent.withTag(key, it.getString(key))
                    }
                }
                AndroidClientMetrics.recordCountEvent(countEvent)
            }
            "timer" -> {
                MolocoLogger.debug(TAG, "Timer metric recorded: $metricName = $metricValue")
                var timerEvent = TimerEvent.create(metricName)
                timerEvent.withTime(metricValue.toLong())
                tags?.let {
                    for (key in it.keys()) {
                        timerEvent = timerEvent.withTag(key, it.getString(key))
                    }
                }
                AndroidClientMetrics.recordTimerEvent(timerEvent)
            }
            else -> {
                MolocoLogger.warn(TAG, "Unknown event type: $eventName")
            }
        }
    }
}