package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.templates.renderer.events.handlers

import com.moloco.sdk.internal.MolocoLogger
import com.moloco.sdk.internal.scheduling.DispatcherProvider
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.templates.renderer.events.EventHandler
import com.moloco.sdk.xenoss.sdkdevkit.android.persistenttransport.PersistentHttpRequest
import io.ktor.http.ContentType
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.launch
import org.json.JSONObject

class HttpEventHandler(private val persistentHttpRequest: PersistentHttpRequest) : EventHandler {

    private val scope = CoroutineScope(DispatcherProvider().io)

    override val TAG: String
        get() = "HttpEventHandler"

    override val supportedEvents: Set<String>
        get() = setOf("sendGet", "sendPost")

    override fun handleEvent(event: JSONObject) {
        when (val eventType = event.getString("event")) {
            "sendGet" -> {
                val url = event.getString("url")
                // Handle GET request
                handleGetRequest(url)
            }
            "sendPost" -> {
                val url = event.getString("url")
                val body = event.getString("body")
                val contentType = ContentType.parse(event.optString("contentType", ContentType.Any.toString()))

                // Handle POST request
                handlePostRequest(url, body, contentType)
            }
            else -> {
                // Unsupported event type
                MolocoLogger.error(TAG, "Unsupported event type: $eventType")
            }
        }
    }

    private fun handleGetRequest(url: String) = scope.launch {
        persistentHttpRequest.send(url)
    }

    private fun handlePostRequest(url: String, data: String, contentType: ContentType) = scope.launch {
        val body = data.toByteArray()
        persistentHttpRequest.sendPost(url, body, contentType)
    }
}
