package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.templates.renderer.events.handlers

import com.moloco.sdk.internal.MolocoLogger
import com.moloco.sdk.internal.scheduling.DispatcherProvider
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.templates.renderer.events.EventHandler
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.flow.MutableSharedFlow
import kotlinx.coroutines.flow.SharedFlow
import kotlinx.coroutines.launch
import org.json.JSONObject

/**
 * Handles the events from template in regards to required content.
 */
class RequiredContentEventHandler(private val scope: CoroutineScope = CoroutineScope(DispatcherProvider().main)
) : EventHandler {

    private val _contentLoadedEvent = MutableSharedFlow<Boolean>(replay = 1)
    internal val contentLoadedEvent: SharedFlow<Boolean> = _contentLoadedEvent

    override val TAG: String
        get() = "RequiredContentEventHandler"

    override val supportedEvents: Set<String>
        get() = setOf("requiredContentLoaded", "requiredContentError")

    override fun handleEvent(event: JSONObject) {
        val eventName = event.getString("event")
        when(eventName) {
            "requiredContentLoaded" -> {
                scope.launch {
                    MolocoLogger.info(TAG, "Content loaded event emitting")
                    _contentLoadedEvent.emit(true)
                    MolocoLogger.info(TAG, "Content loaded event emitted")
                }
            }
            "requiredContentError" -> {
                scope.launch {
                    _contentLoadedEvent.emit(false)
                }
            }
            else -> {
                MolocoLogger.debug(TAG, "Event not handled: $eventName")
            }
        }
    }
}
