package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui.rewardedcountdowntimer

import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.semantics.contentDescription
import androidx.compose.ui.semantics.semantics
import androidx.compose.ui.semantics.testTag
import androidx.compose.ui.unit.DpSize
import androidx.compose.ui.unit.dp
import com.moloco.sdk.internal.Alignment
import com.moloco.sdk.internal.ortb.model.CountDownTimer

@Composable
internal fun AggregateRewardedCountDownTimer(countDownTimer: CountDownTimer,
                                             totalCountDownTime: UInt,
                                             currentCountDownTime: UInt) {
    val circleSize = countDownTimer.circleSize.toInt().dp.let { size -> DpSize(size, size) }
    val alignment = Alignment(countDownTimer.horizontalAlignment, countDownTimer.verticalAlignment)
    val backgroundColor = countDownTimer.backgroundColor
    val foregroundColor = countDownTimer.foregroundColor

    Box(modifier = Modifier
        .fillMaxSize(),
        contentAlignment = alignment) {
        if (countDownTimer.isDefaultTimer) {
            val contentDescription = "rewarded_countdown_timer"
            // Renders with countdown number inside timer
            RewardedCountDownTimer(
                inactiveBarColor = backgroundColor,
                activeBarColor = foregroundColor,
                onTimerFinish = { },
                modifier = Modifier.semantics {
                    contentDescription.let {
                        this.contentDescription = it
                        this.testTag = it
                    }
                },
                circleSize = circleSize.width,
                totalCountDownTime = totalCountDownTime,
                currentCountDownTime = currentCountDownTime,
            )
        } else if (countDownTimer.customTimerDesc?.isNotEmpty() == true) {
            val contentDescription = "rewarded_countdown_timer_custom"
            // Renders with text to left of timer
            RewardedCountDownTimerCustom(
                inactiveBarColor = backgroundColor,
                activeBarColor = foregroundColor,
                onTimerFinish = { },
                modifier = Modifier.semantics {
                    contentDescription.let {
                        this.contentDescription = it
                        this.testTag = it
                    }
                },
                circleSize = circleSize.width,
                customTimerString = countDownTimer.customTimerDesc,
                totalCountDownTime = totalCountDownTime,
                currentCountDownTime = currentCountDownTime,
            )
        }
    }
}

internal fun asProgressRatio(currentTimeLeft: UInt, totalTime: UInt): Float {
    return currentTimeLeft.toFloat() / totalTime.toFloat()
}
