package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.ad

import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.GoNextAction
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.companion.CompanionGoNextAction
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.SharingStarted
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.flow.onEach
import kotlinx.coroutines.flow.stateIn

interface AdGoNextAction : GoNextAction

internal fun AdGoNextAction(
    currentPlaylistItem: StateFlow<PlaylistItem?>,
    scope: CoroutineScope
): AdGoNextAction = AdGoNextActionImpl(
    currentPlaylistItem,
    scope
)

private class AdGoNextActionImpl(
    private val currentPlaylistItem: StateFlow<PlaylistItem?>,
    scope: CoroutineScope
) : AdGoNextAction {

    init {
        // Eagerly subscribe to playlist items changes: reset countdown for companion and DECs on each change;
        // linear takes care of it internally, so no additional calls required.
        currentPlaylistItem.onEach { pi ->
            val resettableGoNextAction: CompanionGoNextAction = when (pi) {
                is PlaylistItem.Companion -> pi.companion
                is PlaylistItem.DEC -> pi.dec
                else -> null
            } ?: return@onEach

            resettableGoNextAction.reset()
        }.stateIn(scope, SharingStarted.Eagerly, null)
    }

    private val unavailableState =
        MutableStateFlow<GoNextAction.State>(GoNextAction.State.Unavailable)

    // https://mlc.atlassian.net/browse/SDK-1308.
    // Workaround, required for providing a correct goNextAction to Compose UI
    // and avoiding inconsistent independent recompositions for the same Composable (VastGoNextButton),
    // which is in sync with currentPlaylistItem.
    @Deprecated("TODO. https://mlc.atlassian.net/browse/SDK-1385")
    override val goNextAction: StateFlow<GoNextAction.State>
        get() = when (val pi = currentPlaylistItem.value) {
            is PlaylistItem.Companion -> pi.companion.goNextAction
            is PlaylistItem.DEC -> pi.dec.goNextAction
            is PlaylistItem.Linear -> pi.linear.goNextAction
            is PlaylistItem.Mraid -> pi.mraid.goNextAction
            null -> unavailableState
        }
}
