package com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.compose

import androidx.compose.animation.animateContentSize
import androidx.compose.foundation.layout.PaddingValues
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.layout.width
import androidx.compose.foundation.layout.widthIn
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material.MaterialTheme
import androidx.compose.material.OutlinedButton
import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.clip
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import coil.compose.AsyncImage
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ui.theme.Theme

@Composable
fun VastCTA(
    modifier: Modifier = Modifier,
    imageUri: String? = null,
    text: String,
    color: Color = MaterialTheme.colors.primary,
    onClick: () -> Unit
) {
    OutlinedButton(
        modifier = modifier
            .height(48.dp)
            .widthIn(max = 156.dp)
            .animateContentSize(),
        onClick = onClick,
        contentPadding = PaddingValues(horizontal = CTA_PADDING)
    ) {
        imageUri?.let {
            AsyncImage(
                modifier = Modifier
                    .clip(RoundedCornerShape(CTA_PADDING))
                    .size(36.dp),
                model = imageUri,
                contentDescription = null
            )

            Spacer(modifier = Modifier.width(CTA_PADDING))
        }

        Text(text = text, maxLines = 1, color = color)
    }
}

private val CTA_PADDING = 4.dp

@Preview
@Composable
private fun VastCTAPreview() {
    Theme {
        VastCTA(
            imageUri = "https://play-lh.googleusercontent.com/l_C7yZC4etIdr5tUY7-7LdKzi_-FWmVhwqMU_OncT9MMntcK-wWBEIvuVrfT1Yoe6Q=s96",
            text = "Learn More",
            onClick = { }
        )
    }
}
