package com.moloco.sdk.internal

/**
 * An error that caused the failure
 * @param description - String description of the error in human readable format
 * @param failureCode - Error code that is associated with
 * the error. For Http errors it can be status code, for others it can be enum value
 */
class Error(val description: String, val failureCode: Int)

sealed class Result<R, E> {
    class Success<R, E>(val value: R) : Result<R, E>()
    class Failure<R, E>(val value: E) : Result<R, E>()
}
