package com.moloco.sdk.internal.error

import androidx.annotation.VisibleForTesting
import com.moloco.sdk.internal.MolocoLogger
import com.moloco.sdk.internal.error.api.ErrorReportingApi
import com.moloco.sdk.internal.services.config.ConfigService

@VisibleForTesting
// Error reporting is controlled via a feature flag sent from backend
internal const val ERROR_REPORTING_FeatureFlag = "ReportSDKError"
internal interface ErrorReportingService {
    fun reportError(error: String, errorMetadata: ErrorMetadata = ErrorMetadata())
}

internal class ErrorReportingServiceImpl(
    private val configService: ConfigService,
    private val errorReportingApi: ErrorReportingApi) : ErrorReportingService {
    private val TAG = "ErrorReportingServiceImpl"

    override fun reportError(error: String, errorMetadata: ErrorMetadata) {
        if (!configService.hasExperimentFeatureFlag(ERROR_REPORTING_FeatureFlag)) {
            MolocoLogger.warn(TAG, "Error reporting is disabled. Tried to report error: $error")
            return
        }

        val url = configService.getExperimentalFeatureFlagValue(ERROR_REPORTING_FeatureFlag)
        if (url == null) {
            MolocoLogger.error(TAG, "Error reporting is enabled but with invalid url")
            return
        }

        errorReportingApi.reportNonFatalError(error, url, errorMetadata)
    }

}
