package com.moloco.sdk.internal.ortb.model

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
internal class BidResponse(
    @SerialName("seatbid") val seatBid: List<SeatBid>
)

@Serializable
internal class SeatBid(
    @SerialName("bid") val bid: List<Bid>,
)

@Serializable
internal class Bid(
    @SerialName("adm") val adm: String,
    @SerialName("price") val price: Float? = null,
    @SerialName("burl") val burl: String? = null,
    @SerialName("ext") val ext: BidExt? = null
)

@Serializable
internal class BidExt(
    @SerialName("player") val player: Player? = null,
    @SerialName("mtid") val mtid: String? = null, // Client sdk can associate the bid with this mtid
    @SerialName("moloco_sdk_events") val sdkEvents: SdkEvents? = null
)

internal fun Bid.mtid(): String {
    return ext?.mtid ?: "UNKNOWN_MTID"
}