package com.moloco.sdk.internal.publisher

import androidx.annotation.VisibleForTesting
import kotlin.time.Duration
import kotlin.time.DurationUnit
import kotlin.time.toDuration

/**
 * Represents the different types of ads that can be created.
 *
 * This enum class defines the various ad formats supported by the ad creation system.
 * Each constant represents a specific ad type, which can be used to configure the ad request
 * and determine the appropriate ad format for display.
 *
 */
internal enum class CreateAdType {
    BANNER, BANNER_TABLET, MREC, NATIVE_AD_MEDIATION, NATIVE_BANNER, INTERSTITIAL, REWARDED
}

internal data class AdCreatorConfiguration(
    val adTimeouts: Map<CreateAdType, Duration> =  CreateAdType.values().associateWith { createAdType ->
        when (createAdType) {
            CreateAdType.BANNER, CreateAdType.BANNER_TABLET, CreateAdType.MREC -> 5.toDuration(DurationUnit.SECONDS)
            CreateAdType.INTERSTITIAL, CreateAdType.REWARDED, CreateAdType.NATIVE_BANNER, CreateAdType.NATIVE_AD_MEDIATION -> 15.toDuration(DurationUnit.SECONDS)
        }
    },
    val defaultTimeoutDuration: Duration = 5.toDuration(DurationUnit.SECONDS),

)
