package com.moloco.sdk.internal.publisher

import com.moloco.sdk.internal.MolocoInternalAdError
import com.moloco.sdk.publisher.MolocoAd

/**
 * Internal listener interface for ad load events.
 */
internal interface InternalAdLoadListener {
    /**
     * Invoked when the ad starts loading
     *
     * @param molocoAd The [MolocoAd] instance that contains information about the ad
     */
    fun onAdLoadStarted(molocoAd: MolocoAd, timestamp: Long)

    /**
     * Invoked when the ad is loaded successfully
     *
     * @param molocoAd The [MolocoAd] instance that contains information about the ad
     */
    fun onAdLoadSuccess(molocoAd: MolocoAd)

    /**
     * Invoked when an error occurs during ad loading
     *
     * @param internalError The [MolocoInternalAdError] instance that contains information about the error
     */
    fun onAdLoadFailed(internalError: MolocoInternalAdError)
}