package com.moloco.sdk.internal.publisher.nativead

import android.annotation.SuppressLint
import android.content.Context
import android.view.ViewGroup
import com.moloco.sdk.internal.mediators.bannerAdLoadTimeout
import com.moloco.sdk.internal.publisher.AdCreateLoadTimeoutManager
import com.moloco.sdk.internal.publisher.BannerImpl
import com.moloco.sdk.internal.publisher.CreateAdObjectTime
import com.moloco.sdk.internal.services.AnalyticsApplicationLifecycleTracker
import com.moloco.sdk.publisher.AdFormatType
import com.moloco.sdk.publisher.AdLoad
import com.moloco.sdk.publisher.Moloco
import com.moloco.sdk.publisher.NativeAdOrtbRequestRequirements
import com.moloco.sdk.publisher.NativeBanner
import com.moloco.sdk.service_locator.SdkObjectFactory
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.NativeAdShowListener
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.NativeAdViewProvider
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.NativeBanner
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.VastAdShowListener
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.WatermarkImpl
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ExternalLinkHandler
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ViewVisibilityTracker
import com.moloco.sdk.xenoss.sdkdevkit.android.core.services.CustomUserEventBuilderService
import com.moloco.sdk.xenoss.sdkdevkit.android.persistenttransport.PersistentHttpRequest

// TODO. Refactor so that there's common logic
//  and also less nested views introduced into for NativeBanner and Banner implementations.
@SuppressLint("ViewConstructor")
internal class NativeBannerImpl(
    context: Context,
    appLifecycleTrackerService: AnalyticsApplicationLifecycleTracker,
    customUserEventBuilderService: CustomUserEventBuilderService,
    adUnitId: String,
    verifyBannerVisible: Boolean,
    nativeParams: NativeParams,
    viewVisibilityTracker: ViewVisibilityTracker,
    externalLinkHandler: ExternalLinkHandler,
    persistentHttpRequest: PersistentHttpRequest,
    private val adCreateLoadTimeoutManager:AdCreateLoadTimeoutManager
) : NativeBanner(context), CreateAdObjectTime by adCreateLoadTimeoutManager {
    class NativeParams(
            val nativeAdViewProvider: NativeAdViewProvider,
            val externalLinkHandler: ExternalLinkHandler,
            val nativeAdOrtbRequestRequirements: NativeAdOrtbRequestRequirements.Requirements,
    )

    private val bannerImpl = BannerImpl(
        context,
        appLifecycleTrackerService,
        customUserEventBuilderService,
        adUnitId,
        verifyBannerVisible,
        externalLinkHandler,
        createXenossBanner = { context, customUsrEvtSrv, bid, externalLinkHandler, _ ->
            NativeBanner(
                    context = context,
                    customUserEventBuilderService = customUsrEvtSrv,
                    adm = bid.adm,
                    nativeAdViewProvider = nativeParams.nativeAdViewProvider,
                    viewVisibilityTracker = viewVisibilityTracker,
                    externalLinkHandler = externalLinkHandler,
                    persistentHttpRequest = persistentHttpRequest,
            )
        },
        ::createNativeBannerAdShowListener,
        watermark = WatermarkImpl(context, null),// watermark will not be applied to Native Banners
        adCreateLoadTimeoutManager,
        SdkObjectFactory.Miscellaneous.viewLifecycleOwnerSingleton,
    ).also {
        // TODO. Refactor so that there's a minimal view hierarchy for banners.
        addView(it, ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT)
    }

    override val nativeAdOrtbRequestRequirements = nativeParams.nativeAdOrtbRequestRequirements

    override var adShowListener by bannerImpl::adShowListener

    override val isViewShown by bannerImpl::isViewShown

    override val isLoaded by bannerImpl::isLoaded

    override fun load(bidResponseJson: String, listener: AdLoad.Listener?) {
        bannerImpl.load(bidResponseJson, listener)
    }

    override fun destroy() {
        bannerImpl.destroy()
        removeView(bannerImpl)
    }
}

private fun createNativeBannerAdShowListener(
    basedOnThisVastAdShowListener: VastAdShowListener
): NativeAdShowListener =
    object : NativeAdShowListener, VastAdShowListener by basedOnThisVastAdShowListener {
    }
