package com.moloco.sdk.internal.publisher.nativead

import com.moloco.sdk.publisher.NativeAdOrtbRequestRequirements
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.nativead.NativeOrtbDataAssetType
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.nativead.NativeOrtbEventTrackerEventType
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.nativead.NativeOrtbEventTrackerMethodType
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.nativead.NativeOrtbImageAssetType

private val EventTrackers by lazy {
    listOf(
        NativeAdOrtbRequestRequirements.Requirements.EventTracker(
            NativeOrtbEventTrackerEventType.Impression,
            listOf(NativeOrtbEventTrackerMethodType.Image)
        )
    )
}

internal val NativeSmall by lazy {
    NativeAdOrtbRequestRequirements.Requirements(
        eventTrackers = EventTrackers,
        assets = listOf(
            Title(),
            SponsorText(),
            CTAText(),
            IconImage(),
            Description(),
            Rating()
        ).associateBy { it.id }
    )
}

val NativeMediumImage by lazy {
    NativeAdOrtbRequestRequirements.Requirements(
        eventTrackers = EventTrackers,
        assets = listOf(
            Title(),
            SponsorText(),
            CTAText(),
            IconImage(),
            MainImage(),
            Description(),
            Rating()
        ).associateBy { it.id }
    )
}

internal val NativeMediumVideo by lazy {
    NativeAdOrtbRequestRequirements.Requirements(
        eventTrackers = EventTrackers,
        assets = listOf(
            Title(),
            SponsorText(),
            CTAText(),
            IconImage(),
            Video(),
            Description(),
            Rating()
        ).associateBy { it.id }
    )
}

internal object NativeAdAssetIds {
    const val ICON = 0
    const val MAIN_IMAGE = 1
    const val THUMBNAIL = 2
    const val VIDEO = 3
    const val TITLE = 4
    const val SPONSOR_TEXT = 5
    const val DESCRIPTION = 6
    const val RATING = 7
    const val CTA_TEXT = 8
}

private fun IconImage(required: Boolean = true) =
    NativeAdOrtbRequestRequirements.Requirements.Asset.Image(
        NativeAdAssetIds.ICON,
        required,
        NativeOrtbImageAssetType.Icon
    )

private fun MainImage(required: Boolean = true) =
    NativeAdOrtbRequestRequirements.Requirements.Asset.Image(
        NativeAdAssetIds.MAIN_IMAGE,
        required,
        NativeOrtbImageAssetType.Main
    )

private fun Thumbnail(required: Boolean = true) =
    NativeAdOrtbRequestRequirements.Requirements.Asset.Image(
        NativeAdAssetIds.THUMBNAIL,
        required,
        NativeAdOrtbRequestRequirements.Requirements.Asset.Image.TypeMolocoThumbnail
    )

private fun Video(required: Boolean = true) =
    NativeAdOrtbRequestRequirements.Requirements.Asset.Video(
        NativeAdAssetIds.VIDEO,
        required
    )

private fun Title(required: Boolean = true) =
    NativeAdOrtbRequestRequirements.Requirements.Asset.Title(
        NativeAdAssetIds.TITLE,
        required,
        length = 70
    )

private fun SponsorText(required: Boolean = false) =
    NativeAdOrtbRequestRequirements.Requirements.Asset.Data(
        NativeAdAssetIds.SPONSOR_TEXT,
        required,
        NativeOrtbDataAssetType.Sponsored,
        len = 25
    )

// TODO. Description IS NOT RENDERED BY TEMPLATES YET (WIP on creative team side.
//  https://www.figma.com/file/lIwzPugngoeKs387EbbC5m/Native-Ads?type=design&node-id=0-1&mode=design&t=HVSz7dQDuAQAvg4m-0
private fun Description(required: Boolean = false) =
    NativeAdOrtbRequestRequirements.Requirements.Asset.Data(
        NativeAdAssetIds.DESCRIPTION,
        required,
        NativeOrtbDataAssetType.Description,
        len = 150
    )

private fun Rating(required: Boolean = false) =
    NativeAdOrtbRequestRequirements.Requirements.Asset.Data(
        NativeAdAssetIds.RATING,
        required,
        NativeOrtbDataAssetType.Rating,
        len = 5
    )

private fun CTAText(required: Boolean = true) =
    NativeAdOrtbRequestRequirements.Requirements.Asset.Data(
        NativeAdAssetIds.CTA_TEXT,
        required,
        NativeOrtbDataAssetType.CTAText,
        len = 100
    )
