package com.moloco.sdk.internal.publisher.nativead

import android.content.Context
import com.moloco.sdk.internal.ViewLifecycleOwner
import com.moloco.sdk.internal.publisher.AdCreateLoadTimeoutManager
import com.moloco.sdk.internal.services.AnalyticsApplicationLifecycleTracker
import com.moloco.sdk.internal.services.AudioService
import com.moloco.sdk.publisher.AdFormatType
import com.moloco.sdk.publisher.NativeAdForMediation
import com.moloco.sdk.publisher.NativeAdOrtbRequestRequirements
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ExternalLinkHandler
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ViewVisibilityTracker
import com.moloco.sdk.xenoss.sdkdevkit.android.core.services.CustomUserEventBuilderService
import com.moloco.sdk.xenoss.sdkdevkit.android.persistenttransport.PersistentHttpRequest

internal fun NativeAdForMediationSmall(
        context: Context,
        appLifecycleTrackerService: AnalyticsApplicationLifecycleTracker,
        customUserEventBuilderService: CustomUserEventBuilderService,
        audioService: AudioService,
        adUnitId: String,
        viewVisibilityTracker: ViewVisibilityTracker,
        externalLinkHandler: ExternalLinkHandler,
        persistentHttpRequest: PersistentHttpRequest,
        viewLifecycleOwnerSingleton: ViewLifecycleOwner,
): NativeAdForMediation = NativeAdForMediationImpl(
    context,
    appLifecycleTrackerService,
    customUserEventBuilderService,
    audioService,
    adUnitId,
    viewVisibilityTracker,
    externalLinkHandler,
    persistentHttpRequest,
    NativeSmall,
    AdCreateLoadTimeoutManager(getAdFormatType(NativeSmall), NativeAdForMediationImpl.LOAD_TIMEOUT),
    viewLifecycleOwnerSingleton,
)

internal fun NativeAdForMediationMediumImage(
        context: Context,
        appLifecycleTrackerService: AnalyticsApplicationLifecycleTracker,
        customUserEventBuilderService: CustomUserEventBuilderService,
        audioService: AudioService,
        adUnitId: String,
        viewVisibilityTracker: ViewVisibilityTracker,
        externalLinkHandler: ExternalLinkHandler,
        persistentHttpRequest: PersistentHttpRequest,
        viewLifecycleOwnerSingleton: ViewLifecycleOwner,
): NativeAdForMediation = NativeAdForMediationImpl(
    context,
    appLifecycleTrackerService,
    customUserEventBuilderService,
    audioService,
    adUnitId,
    viewVisibilityTracker,
    externalLinkHandler,
    persistentHttpRequest,
    NativeMediumImage,
    AdCreateLoadTimeoutManager(getAdFormatType(NativeMediumImage), NativeAdForMediationImpl.LOAD_TIMEOUT),
    viewLifecycleOwnerSingleton,
)

internal fun NativeAdForMediationMediumVideo(
        context: Context,
        appLifecycleTrackerService: AnalyticsApplicationLifecycleTracker,
        customUserEventBuilderService: CustomUserEventBuilderService,
        audioService: AudioService,
        adUnitId: String,
        viewVisibilityTracker: ViewVisibilityTracker,
        externalLinkHandler: ExternalLinkHandler,
        persistentHttpRequest: PersistentHttpRequest,
        viewLifecycleOwnerSingleton: ViewLifecycleOwner,
): NativeAdForMediation = NativeAdForMediationImpl(
    context,
    appLifecycleTrackerService,
    customUserEventBuilderService,
    audioService,
    adUnitId,
    viewVisibilityTracker,
    externalLinkHandler,
    persistentHttpRequest,
    NativeMediumVideo,
    AdCreateLoadTimeoutManager(getAdFormatType(NativeMediumVideo), NativeAdForMediationImpl.LOAD_TIMEOUT),
    viewLifecycleOwnerSingleton,
)

/**
 * Takes
 * [com.moloco.sdk.internal.publisher.nativead.NativeSmall]
 * [com.moloco.sdk.internal.publisher.nativead.NativeMediumImage]
 * [com.moloco.sdk.internal.publisher.nativead.NativeMediumVideo]
 * requirements vals and maps to an AdFormatType
 */
private val requirementToAdFormatTypeMap = mapOf(
    NativeSmall to AdFormatType.NATIVE_SMALL_IMAGE,
    NativeMediumImage to AdFormatType.NATIVE_MEDIUM_IMAGE,
    NativeMediumVideo to AdFormatType.NATIVE_MEDIUM_VIDEO
)

/**
 * Gives the native ad type based on ORTB requirements
 * Default for now will be: NATIVE_MEDIUM_IMAGE
 */
internal fun getAdFormatType(requirements: NativeAdOrtbRequestRequirements.Requirements): AdFormatType {
    return requirementToAdFormatTypeMap[requirements]?: AdFormatType.NATIVE_MEDIUM_IMAGE
}
