package com.moloco.sdk.internal.publisher.nativead

import android.content.Context
import com.moloco.sdk.internal.publisher.AdCreateLoadTimeoutManager
import com.moloco.sdk.internal.publisher.nativead.nativeadviewprovider.NativeMediumImageAdViewProvider
import com.moloco.sdk.internal.publisher.nativead.nativeadviewprovider.NativeMediumVideoAdViewProvider
import com.moloco.sdk.internal.publisher.nativead.nativeadviewprovider.NativeSmallAdViewProvider
import com.moloco.sdk.internal.services.AnalyticsApplicationLifecycleTracker
import com.moloco.sdk.publisher.NativeBanner
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ExternalLinkHandler
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ViewVisibilityTracker
import com.moloco.sdk.xenoss.sdkdevkit.android.core.services.CustomUserEventBuilderService
import com.moloco.sdk.xenoss.sdkdevkit.android.persistenttransport.PersistentHttpRequest

internal fun NativeBannerSmall(
    context: Context,
    appLifecycleTrackerService: AnalyticsApplicationLifecycleTracker,
    customUserEventBuilderService: CustomUserEventBuilderService,
    adUnitId: String,
    verifyBannerVisible: Boolean,
    viewVisibilityTracker: ViewVisibilityTracker,
    externalLinkHandler: ExternalLinkHandler,
    persistentHttpRequest: PersistentHttpRequest,
    adCreateLoadTimeoutManager: AdCreateLoadTimeoutManager,
): NativeBanner {
    val requirements = NativeSmall

    return NativeBannerImpl(
        context,
        appLifecycleTrackerService,
        customUserEventBuilderService,
        adUnitId,
        verifyBannerVisible,
        NativeBannerImpl.NativeParams(
            NativeSmallAdViewProvider(),
            externalLinkHandler,
            requirements
        ),
        viewVisibilityTracker,
        externalLinkHandler,
        persistentHttpRequest,
        adCreateLoadTimeoutManager,
    )
}

internal fun NativeBannerMediumImage(
    context: Context,
    appLifecycleTrackerService: AnalyticsApplicationLifecycleTracker,
    customUserEventBuilderService: CustomUserEventBuilderService,
    adUnitId: String,
    verifyBannerVisible: Boolean,
    viewVisibilityTracker: ViewVisibilityTracker,
    externalLinkHandler: ExternalLinkHandler,
    persistentHttpRequest: PersistentHttpRequest,
    adCreateLoadTimeoutManager: AdCreateLoadTimeoutManager,
): NativeBanner {
    val requirements = NativeMediumImage

    return NativeBannerImpl(
        context,
        appLifecycleTrackerService,
        customUserEventBuilderService,
        adUnitId,
        verifyBannerVisible,
        NativeBannerImpl.NativeParams(
            NativeMediumImageAdViewProvider(),
            externalLinkHandler,
            requirements
        ),
        viewVisibilityTracker,
        externalLinkHandler,
        persistentHttpRequest,
        adCreateLoadTimeoutManager,
    )
}

internal fun NativeBannerMediumVideo(
    context: Context,
    appLifecycleTrackerService: AnalyticsApplicationLifecycleTracker,
    customUserEventBuilderService: CustomUserEventBuilderService,
    adUnitId: String,
    verifyBannerVisible: Boolean,
    viewVisibilityTracker: ViewVisibilityTracker,
    externalLinkHandler: ExternalLinkHandler,
    persistentHttpRequest: PersistentHttpRequest,
    adCreateLoadTimeoutManager: AdCreateLoadTimeoutManager,
): NativeBanner {
    val requirements = NativeMediumVideo

    return NativeBannerImpl(
        context,
        appLifecycleTrackerService,
        customUserEventBuilderService,
        adUnitId,
        verifyBannerVisible,
        NativeBannerImpl.NativeParams(
            NativeMediumVideoAdViewProvider(externalLinkHandler),
            externalLinkHandler,
            requirements
        ),
        viewVisibilityTracker,
        externalLinkHandler,
        persistentHttpRequest,
        adCreateLoadTimeoutManager,
    )
}
