package com.moloco.sdk.internal.publisher.nativead.nativeadviewprovider

import android.content.Context
import android.view.View
import com.moloco.sdk.internal.publisher.nativead.NativeAdAssetIds
import com.moloco.sdk.internal.publisher.nativead.ui.templates.NativeMediumImage
import com.moloco.sdk.internal.publisher.nativead.ui.templates.NativeMediumImageData
import com.moloco.sdk.internal.publisher.nativead.ui.templates.NativeTemplateBaseData
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.NativeAdViewProvider
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ViewVisibilityTracker
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.errors.MolocoAdSubErrorType
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.nativead.PreparedNativeAssets
import com.moloco.sdk.xenoss.sdkdevkit.android.core.services.CustomUserEventBuilderService

internal class NativeMediumImageAdViewProvider : NativeAdViewProvider {
    override fun createNativeAdView(
        context: Context,
        customUserEventBuilderService: CustomUserEventBuilderService,
        assets: PreparedNativeAssets,
        onAssetClick: (assetId: Int?) -> Unit,
        onVastCompletionStatus: (skipped: Boolean) -> Unit,
        privacyButtonRequired: Boolean,
        viewVisibilityTracker: ViewVisibilityTracker,
        onPrivacyClick: () -> Unit,
        onError: (internalError: MolocoAdSubErrorType, assetId: Int?) -> Unit
    ): View? {
        val mainImage = assets.provideMainImage(onAssetClick) ?: return null
        val title = assets.provideTitle(onAssetClick) ?: return null
        val icon = assets.provideIcon(onAssetClick) ?: return null
        val cta = assets.provideCTAText(onAssetClick) ?: return null

        val sponsored = assets.provideSponsored(onAssetClick)
        val rating = assets.provideRating(onAssetClick)

        val privacyOnClick = createPrivacyOnClick(privacyButtonRequired, onPrivacyClick)
        val mainLinkOnClick = createContainerOnClick(onAssetClick)

        return NativeAdComposeViewWrapper(context) {
            NativeMediumImage(
                modifier = it,
                data = NativeMediumImageData(
                    mainImage,
                    title,
                    sponsored,
                    icon,
                    rating,
                    cta,
                    privacyOnClick,
                    mainLinkOnClick
                )
            )
        }
    }

    override fun destroy() {
        // noop
    }
}

internal fun PreparedNativeAssets.provideMainImage(
    onAssetIdClick: OnAssetIdClick
): NativeTemplateBaseData.Image? = images[NativeAdAssetIds.MAIN_IMAGE]?.let {
    NativeTemplateBaseData.Image(it.precachedAssetUri, it.createOnClick(onAssetIdClick))
}
