package com.moloco.sdk.internal.publisher.nativead.nativeadviewprovider

import android.content.Context
import android.view.View
import com.moloco.sdk.internal.publisher.nativead.NativeAdAssetIds
import com.moloco.sdk.internal.publisher.nativead.ui.templates.NativeMediumVideo
import com.moloco.sdk.internal.publisher.nativead.ui.templates.NativeMediumVideoData
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.NativeAdViewProvider
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ExternalLinkHandler
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ViewVisibilityTracker
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.errors.MolocoAdSubErrorType
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.errors.NativeAdShowError
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.nativead.PreparedNativeAssets
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.ad.AdController
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.ad.vastAdPlaylistController
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.vast.render.ad.AdControllerEvent
import com.moloco.sdk.xenoss.sdkdevkit.android.core.services.CustomUserEventBuilderService
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.MainScope
import kotlinx.coroutines.cancel
import kotlinx.coroutines.flow.launchIn
import kotlinx.coroutines.flow.onEach

internal class NativeMediumVideoAdViewProvider(
    private val externalLinkHandler: ExternalLinkHandler
) : NativeAdViewProvider {

    private var vastAdController: AdController? = null

    private var scope: CoroutineScope? = null

    override fun createNativeAdView(
        context: Context,
        customUserEventBuilderService: CustomUserEventBuilderService,
        assets: PreparedNativeAssets,
        onAssetClick: (assetId: Int?) -> Unit,
        onVastCompletionStatus: (skipped: Boolean) -> Unit,
        privacyButtonRequired: Boolean,
        viewVisibilityTracker: ViewVisibilityTracker,
        onPrivacyClick: () -> Unit,
        onError: (internalError: MolocoAdSubErrorType, assetId: Int?) -> Unit
    ): View? {
        val title = assets.provideTitle(onAssetClick) ?: return null
        val icon = assets.provideIcon(onAssetClick) ?: return null
        val cta = assets.provideCTAText(onAssetClick) ?: return null

        val videoAssetId = NativeAdAssetIds.VIDEO
        val videoAsset = assets.videos[videoAssetId] ?: return null

        destroy()

        val scope = MainScope()
        this.scope = scope

        val vastAdController = vastAdPlaylistController(
            videoAsset.vastAd,
            externalLinkHandler,
            context,
            mute = true,
            overrideLinearGoNextActionEnabled = false,
            overrideLinearGoNextActionEnabledDelaySeconds = 0,
            companionGoNextActionDelaySeconds = 0,
            decGoNextActionDelaySeconds = 0,
            autoStoreOnComplete = false,
            autoStoreOnSkip = false,
            customUserEventBuilderService = customUserEventBuilderService
        )
        this.vastAdController = vastAdController

        vastAdController.event.onEach { event ->
            when (event) {
                is AdControllerEvent.Error -> onError(NativeAdShowError.NATIVE_AD_MEDIUM_VIEW_VAST_ASSET_LOAD_ERROR, videoAssetId)
                AdControllerEvent.Skip -> onVastCompletionStatus(false)
                AdControllerEvent.Complete -> onVastCompletionStatus(true)
                else -> {}
            }
        }.launchIn(scope)

        vastAdController.show()

        return NativeAdComposeViewWrapper(context) {
            NativeMediumVideo(
                modifier = it,
                viewVisibilityTracker = viewVisibilityTracker,
                data = NativeMediumVideoData(
                    NativeMediumVideoData.Video(
                        vastAdController,
                        videoAsset.createOnClick(onAssetClick)
                    ),
                    title,
                    assets.provideSponsored(onAssetClick),
                    icon,
                    assets.provideRating(onAssetClick),
                    cta,
                    createPrivacyOnClick(privacyButtonRequired, onPrivacyClick),
                    createContainerOnClick(onAssetClick)
                )
            )
        }
    }

    override fun destroy() {
        vastAdController?.destroy()
        vastAdController = null

        scope?.cancel()
        scope = null
    }
}
