package com.moloco.sdk.internal.publisher.nativead.nativeadviewprovider

import android.content.Context
import android.view.View
import com.moloco.sdk.internal.publisher.nativead.ui.templates.NativeSmall
import com.moloco.sdk.internal.publisher.nativead.ui.templates.NativeTemplateBaseData
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.NativeAdViewProvider
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.ViewVisibilityTracker
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.errors.MolocoAdSubErrorType
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.nativead.PreparedNativeAssets
import com.moloco.sdk.xenoss.sdkdevkit.android.core.services.CustomUserEventBuilderService

internal class NativeSmallAdViewProvider : NativeAdViewProvider {
    override fun createNativeAdView(
        context: Context,
        customUserEventBuilderService: CustomUserEventBuilderService,
        assets: PreparedNativeAssets,
        onAssetClick: (assetId: Int?) -> Unit,
        onVastCompletionStatus: (skipped: Boolean) -> Unit,
        privacyButtonRequired: Boolean,
        viewVisibilityTracker: ViewVisibilityTracker,
        onPrivacyClick: () -> Unit,
        onError: (internalError: MolocoAdSubErrorType, assetId: Int?) -> Unit
    ): View? {
        val title = assets.provideTitle(onAssetClick) ?: return null
        val icon = assets.provideIcon(onAssetClick) ?: return null
        val cta = assets.provideCTAText(onAssetClick) ?: return null

        val sponsored = assets.provideSponsored(onAssetClick)
        val rating = assets.provideRating(onAssetClick)

        val privacyOnClick = createPrivacyOnClick(privacyButtonRequired, onPrivacyClick)
        val mainLinkOnClick = createContainerOnClick(onAssetClick)

        return NativeAdComposeViewWrapper(context) {
            NativeSmall(
                modifier = it,
                data = NativeTemplateBaseData(
                    title,
                    sponsored,
                    icon,
                    rating,
                    cta,
                    privacyOnClick,
                    mainLinkOnClick
                )
            )
        }
    }

    override fun destroy() {
        // noop
    }
}
