package com.moloco.sdk.internal.publisher.nativead.nativeadviewprovider

import com.moloco.sdk.internal.publisher.nativead.NativeAdAssetIds
import com.moloco.sdk.internal.publisher.nativead.ui.templates.NativeAssetOnClick
import com.moloco.sdk.internal.publisher.nativead.ui.templates.NativeTemplateBaseData
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.nativead.PreparedNativeAsset
import com.moloco.sdk.xenoss.sdkdevkit.android.adrenderer.internal.nativead.PreparedNativeAssets

internal fun PreparedNativeAssets.provideTitle(
    onAssetIdClick: OnAssetIdClick
): NativeTemplateBaseData.TextField? = titles[NativeAdAssetIds.TITLE]?.let {
    NativeTemplateBaseData.TextField(it.text, it.createOnClick(onAssetIdClick))
}

internal fun PreparedNativeAssets.provideDescription(
    onAssetIdClick: OnAssetIdClick
): NativeTemplateBaseData.TextField? = titles[NativeAdAssetIds.DESCRIPTION]?.let {
    NativeTemplateBaseData.TextField(it.text, it.createOnClick(onAssetIdClick))
}

internal fun PreparedNativeAssets.provideSponsored(
    onAssetIdClick: OnAssetIdClick
): NativeTemplateBaseData.TextField? = data[NativeAdAssetIds.SPONSOR_TEXT]?.let {
    NativeTemplateBaseData.TextField(it.value, it.createOnClick(onAssetIdClick))
}

internal fun PreparedNativeAssets.provideIcon(
    onAssetIdClick: OnAssetIdClick
): NativeTemplateBaseData.Image? = images[NativeAdAssetIds.ICON]?.let {
    NativeTemplateBaseData.Image(it.precachedAssetUri, it.createOnClick(onAssetIdClick))
}

internal fun PreparedNativeAssets.provideRating(
    onAssetIdClick: OnAssetIdClick
): NativeTemplateBaseData.Rating? = data[NativeAdAssetIds.RATING]?.let {
    NativeTemplateBaseData.Rating(
        stars = it.value.toFloatOrNull() ?: 0F,
        outOf = 5,
        it.createOnClick(onAssetIdClick)
    )
}

internal fun PreparedNativeAssets.provideCTAText(
    onAssetIdClick: OnAssetIdClick
): NativeTemplateBaseData.CTA? = data[NativeAdAssetIds.CTA_TEXT]?.let {
    NativeTemplateBaseData.CTA(
        text = it.value,
        onClick = { onAssetIdClick(it.id) }
    )
}

internal typealias OnAssetIdClick = (assetId: Int?) -> Unit

internal fun createPrivacyOnClick(
    privacyButtonRequired: Boolean,
    onPrivacyClick: () -> Unit
): NativeAssetOnClick = if (privacyButtonRequired) onPrivacyClick else null

internal fun createContainerOnClick(onAssetIdClick: OnAssetIdClick): NativeAssetOnClick =
    { onAssetIdClick(null) }

internal fun PreparedNativeAsset.createOnClick(onAssetIdClick: OnAssetIdClick): NativeAssetOnClick =
// TODO. Refactor. We can't know if absence of `link` means not adding onClick handler to view:
    //  check NativeBannerImpl.kt::onAssetClick() code.
    link?.let {
        { onAssetIdClick(id) }
    }
