package com.moloco.sdk.internal.publisher.nativead.ui

import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.PaddingValues
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material.Button
import androidx.compose.material.ButtonDefaults
import androidx.compose.material.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.RectangleShape
import androidx.compose.ui.graphics.Shape
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.TextUnit
import androidx.compose.ui.unit.dp
import androidx.compose.ui.unit.sp
import com.moloco.sdk.internal.MolocoBlue

// small - for small native ad template
// medium - for medium native ad template
// https://www.figma.com/file/lIwzPugngoeKs387EbbC5m/Native-Ads?type=design&node-id=0-1&mode=design&t=E4KnEhnieHCUxvGd-0

@Composable
internal fun CTASmall(modifier: Modifier = Modifier, text: String, onClick: () -> Unit) {
    CTA(
        modifier = modifier.size(94.dp, 30.dp),
        shape = CTASmallShape,
        fontSize = CTASmallFontSize,
        text = text,
        onClick = onClick
    )
}

private val CTASmallShape = RoundedCornerShape(3.dp)
private val CTASmallFontSize = 10.sp

@Composable
internal fun CTAMedium(modifier: Modifier = Modifier, text: String, onClick: () -> Unit) {
    CTA(
        modifier = modifier.fillMaxWidth().height(33.dp),
        shape = CTAMediumShape,
        fontSize = CTAMediumFontSize,
        text = text,
        onClick = onClick
    )
}

private val CTAMediumShape = RectangleShape
private val CTAMediumFontSize = 12.sp

@Composable
private fun CTA(
    modifier: Modifier = Modifier,
    shape: Shape,
    fontSize: TextUnit,
    text: String,
    onClick: () -> Unit
) {
    Button(
        modifier = modifier,
        contentPadding = PaddingValues,
        colors = ButtonDefaults.textButtonColors(
            backgroundColor = MolocoBlue,
            contentColor = Color.White
        ),
        shape = shape,
        onClick = onClick
    ) {
        NativeAdText(
            text = text,
            fontWeight = FontWeight.W600,
            fontSize = fontSize,
            maxLines = 1,
            onClick = null
        )
    }
}

private val PaddingValues = PaddingValues(horizontal = 10.dp)

@Composable
@Preview
private fun CTAPreview() {
    MaterialTheme {
        Column {
            CTASmall(
                text = "Download Now"
            ) {
                TODO()
            }

            Spacer(modifier = Modifier.size(10.dp))

            CTAMedium(
                text = "Download Now"
            ) {
            }
        }
    }
}
