package com.moloco.sdk.internal.publisher.nativead.ui

import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.clip
import androidx.compose.ui.layout.ContentScale
import androidx.compose.ui.tooling.preview.Preview
import androidx.compose.ui.unit.dp
import coil.compose.AsyncImage
import com.moloco.sdk.internal.publisher.nativead.ui.templates.NativeAssetOnClick

// small - for small native ad template
// medium - for medium native ad template
// https://www.figma.com/file/lIwzPugngoeKs387EbbC5m/Native-Ads?type=design&node-id=0-1&mode=design&t=E4KnEhnieHCUxvGd-0

@Composable
internal fun IconImageSmall(
    modifier: Modifier = Modifier,
    imageUri: String,
    onClick: NativeAssetOnClick
) {
    IconImage(
        modifier = modifier.size(64.dp),
        imageUri = imageUri,
        roundedCornerShape = RoundedCornerShapeSmall,
        onClick = onClick
    )
}

private val RoundedCornerShapeSmall = RoundedCornerShape(7.dp)

@Composable
internal fun IconImageMedium(
    modifier: Modifier = Modifier,
    imageUri: String,
    onClick: NativeAssetOnClick
) {
    IconImage(
        modifier = modifier.size(42.dp),
        imageUri = imageUri,
        roundedCornerShape = RoundedCornerShapeMedium,
        onClick = onClick
    )
}

private val RoundedCornerShapeMedium = RoundedCornerShape(5.dp)

@Composable
private fun IconImage(
    modifier: Modifier = Modifier,
    imageUri: String,
    roundedCornerShape: RoundedCornerShape,
    onClick: NativeAssetOnClick
) {
    AsyncImage(
        modifier = modifier
            .clip(roundedCornerShape)
            .clickable(onClick),
        model = imageUri,
        contentScale = ContentScale.Crop,
        contentDescription = "ad icon"
    )
}

@Preview(showBackground = true)
@Composable
private fun IconImagePreview() {
    MaterialTheme {
        Column {
            val uri =
                "https://images.unsplash.com/photo-1526547541286-73a7aaa08f2a?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxleHBsb3JlLWZlZWR8Mnx8fGVufDB8fHx8fA%3D%3D&w=1000&q=80"

            IconImageSmall(
                imageUri = uri,
                onClick = { }
            )

            IconImageMedium(
                imageUri = uri,
                onClick = null
            )
        }
    }
}
