package com.moloco.sdk.internal.publisher.nativead.ui

import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.unit.sp
import com.moloco.sdk.R
import com.moloco.sdk.internal.publisher.nativead.ui.templates.NativeAssetOnClick

// small - for small native ad template
// medium - for medium native ad template
// https://www.figma.com/file/lIwzPugngoeKs387EbbC5m/Native-Ads?type=design&node-id=0-1&mode=design&t=E4KnEhnieHCUxvGd-0

@Composable
internal fun TitleSmall(modifier: Modifier = Modifier, text: String, onClick: NativeAssetOnClick) {
    NativeAdText(
        modifier,
        text = text,
        fontSize = 15.sp,
        fontWeight = TitleFontWeight,
        color = TitleColor,
        onClick = onClick
    )
}

@Composable
internal fun TitleMedium(modifier: Modifier = Modifier, text: String, onClick: NativeAssetOnClick) {
    NativeAdText(
        modifier,
        text = text,
        fontSize = 12.sp,
        fontWeight = TitleFontWeight,
        color = TitleColor,
        onClick = onClick
    )
}

private val TitleColor = Color(0xFF505050)
private val TitleFontWeight = FontWeight.W700

@Composable
internal fun SponsorLabel(modifier: Modifier = Modifier) {
    NativeAdText(
        modifier,
        text = stringResource(id = R.string.moloco_sponsored),
        fontSize = 8.sp,
        fontWeight = SponsorTextWeight,
        color = Color(0xFF969696),
        onClick = null
    )
}

@Composable
internal fun SponsorTextSmall(
    modifier: Modifier = Modifier,
    text: String,
    onClick: NativeAssetOnClick
) {
    NativeAdText(
        modifier,
        text = text,
        fontSize = 12.sp,
        fontWeight = SponsorTextWeight,
        color = TitleColor,
        onClick = onClick
    )
}

@Composable
internal fun SponsorTextMedium(
    modifier: Modifier = Modifier,
    text: String,
    onClick: NativeAssetOnClick
) {
    NativeAdText(
        modifier,
        text = text,
        fontSize = 10.sp,
        fontWeight = SponsorTextWeight,
        color = TitleColor,
        onClick = onClick
    )
}

private val SponsorTextWeight = FontWeight.W400
